<?
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

// файл локализации
include(GetLangFileName(dirname(__FILE__) . '/', '/ucs.php'));
// модуль UCS
CModule::IncludeModule('ucs');
// путь к шаблонам
$templateDir = dirname(__FILE__) . '/templates/' . LANGUAGE_ID . '/';

// имя сайта для использования в ссылках
$SERVER_NAME_tmp = '';
if (defined('SITE_SERVER_NAME')) {
    $SERVER_NAME_tmp = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . SITE_SERVER_NAME;
}
if (strlen($SERVER_NAME_tmp) <= 0) {
    $SERVER_NAME_tmp = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . COption::GetOptionString('main', 'server_name', '');
}

try {
    $orderSum = CSalePaySystemAction::GetParamValue('SHOULD_PAY');
    if (false !== $i = strrpos($orderSum, ',')) {
        $orderSum[$i] = '.';
    }
    $orderSum = preg_replace('/[^0-9.]/', '', $orderSum);
    if (!CModule::IncludeModule("sale")) return;
    if (!CModule::IncludeModule("catalog")) return;

    $arBasketItems = array();
    $dbBasketItems = CSaleBasket::GetList(
            array(
                    "NAME" => "ASC",
                    "ID" => "ASC"
                ),
            array(
                    "ORDER_ID" => CSalePaySystemAction::GetParamValue('ORDER_ID')
                ),
            false,
            false,
            array("PRODUCT_ID","NAME",  "PRICE", "QUANTITY")
        );
    while ($arItems = $dbBasketItems->Fetch())
    {
        $arItem = array();

        $arItem['PRICE'] = preg_replace('/[^0-9.]/', '', $arItems["PRICE"]);
        $arItem['QUANTITY'] = $arItems["QUANTITY"];
        $arItem['NAME'] = $arItems["NAME"];
        $arItemsCat = CCatalogProduct::GetByID($arItems["PRODUCT_ID"]);
        $arVAT = CCatalogVat::GetByID($arItemsCat["VAT_ID"])->Fetch();
        $arItem['VAT'] = CSalePaySystemAction::GetParamValue('SHOP_FISC_RATE');
        if ($arItem['VAT'] != 'no') {
            $arItem['VAT_VALUE'] = preg_replace('/[^0-9.]/', '', $arItem['PRICE'] * $arItem['VAT'] / (100+$arItem['VAT']));
        } else {
            $arItem['VAT_VALUE'] = 0;
        }
        $arItem['TYPENAME'] = 'goods';
        $arBasketItems[] = $arItem;
    }
    
    $arOrder = CSaleOrder::GetByID(CSalePaySystemAction::GetParamValue('ORDER_ID'));
    $arItem = array();
    $arItem['PRICE'] = preg_replace('/[^0-9.]/', '', $arOrder["PRICE_DELIVERY"]);
    $arItem['QUANTITY'] = 1;
    $arItem['NAME'] ='доставка';
    $arItem['VAT'] = CSalePaySystemAction::GetParamValue('SHOP_FISC_RATE');
    if ($arItem['VAT'] != 'no') {
        $arItem['VAT_VALUE'] = preg_replace('/[^0-9.]/', '', $arItem['PRICE'] * $arItem['VAT'] / 118);
    } else {
        $arItem['VAT_VALUE'] = 0;
    }
    $arItem['TYPENAME'] = 'service';
    $arBasketItems[] = $arItem;

    // массив с данными по магазину и заказу
    $settings = array(
        'shop_id' => CSalePaySystemAction::GetParamValue('SHOP_ID'),
        'shop_login' => CSalePaySystemAction::GetParamValue('SHOP_LOGIN'),
        'shop_pass' => CSalePaySystemAction::GetParamValue('SHOP_PASSWORD'),
        'shop_url' => CSalePaySystemAction::GetParamValue('SHOP_URL'),
        'order_id' => CSalePaySystemAction::GetParamValue('ORDER_ID'),
        'order_sum' => round($orderSum, 2),
        'basket_items' => $arBasketItems,
        'user_id' => CSalePaySystemAction::GetParamValue('USER_ID'),
        'user_name' => mb_convert_encoding(CSalePaySystemAction::GetParamValue('USER_NAME'), 'UTF-8', LANG_CHARSET),
        'user_email' => CSalePaySystemAction::GetParamValue('USER_EMAIL'),
        'user_phone' => CSalePaySystemAction::GetParamValue('USER_PHONE'),
        'return_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . CSalePaySystemAction::GetParamValue('ORDER_ID'),
        'comment' => CSalePaySystemAction::GetParamValue('COMMENT'),
        'item_type' => CSalePaySystemAction::GetParamValue('ITEM_TYPE'),
        'item_desc' => CSalePaySystemAction::GetParamValue('ITEM_DESC'),
        'shop_fisc' => CSalePaySystemAction::GetParamValue('SHOP_FISC'),
        'shop_fisc_rate' => CSalePaySystemAction::GetParamValue('SHOP_FISC_RATE'),
    );
} catch (Exception $e) {
    Cucs::fetch($templateDir . 'error.tpl', array('e' => $e->__toString()));
}


if (isset($_REQUEST['status'])) {
    // заказ отработан

    if ($_REQUEST['status'] == 'ok') {
        // заказ проведён успешно, проверяем статус

        $soapClient = Cucs::newSoap($settings);
        $objStatus = Cucs::getOrderStatus($settings['shop_id'], $settings['order_id']);

        // получаем данные по заказу
        $order = Bitrix\Sale\Order::load($settings['order_id']);
        $arOrder = $order->getFieldValues();

        try {
            // получаем статуса заказа от платёжной системы
            $info = $soapClient->get_status($objStatus);

            switch ($info->status) {
                case 'acknowledged':
                case 'not_acknowledged':
                case 'authorized':
                    Cucs::updatePaymentStatus($order, 'Y', $info->status, $info->status);
                    CSaleOrder::StatusOrder($settings['order_id'], CSalePaySystemAction::GetParamValue('PAY_STATUS'));

                    // переменные для вывода в шаблоне
                    $templateOrderStatus = GetMessage('UCS_ORDER_SUCCESS');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/detail/' . $settings['order_id'] . '/';
                break;

                case 'canceled':
                case 'not_authorized':
                    // оплата заказа не удалась
                    Cucs::updatePaymentStatus($order, 'N', $info->status, $info->status);
                    CSaleOrder::StatusOrder($settings['order_id'], 'N');

                    $templateOrderStatus = GetMessage('UCS_ORDER_FAIL');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/detail/' . $settings['order_id'] . '/';
                break;

                case 'registered':
                    $templateOrderStatus = GetMessage('UCS_ORDER_REGISTERED');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'] . '&status=ok';
                break;

                case 'failed':
                case 'in_progress':
                    $templateOrderStatus = GetMessage('UCS_ORDER_IN_PROGRESS');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'] . '&status=ok';
                break;

                default:
                    $templateOrderStatus = GetMessage('UCS_ORDER_PROCESSING');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/detail/' . $settings['order_id'] . '/';

                break;
            }

        } catch (SoapFault $fault) {
            if ($fault->faultstring === 'INVALID_ORDER') {
                // заказ с таким номером не зарегистрирован
                Cucs::updatePaymentStatus($order, 'N', GetMessage('UCS_ORDER_INVALID'), $fault->faultstring);
                CSaleOrder::StatusOrder($settings['order_id'], 'N');

                $templateOrderStatus = GetMessage('UCS_ORDER_FAIL');
                $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'];
            }
        } catch (Exception $e) {
            Cucs::fetch($templateDir . 'pay_fault.tpl', array('form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'], 'e' => $e->__toString()));
        }

        // выводим шаблон с информацией о статусе заказа
        Cucs::fetch($templateDir . 'order_status.tpl', array(
                                                                'order_status' => $templateOrderStatus,
                                                                'redirect_url' => $templateRedirectUrl,
                                                                'detail_url' => $SERVER_NAME_tmp . '/personal/order/detail/' . intval($_REQUEST['ORDER_ID']) . '/'));
    }

    if ($_REQUEST['status'] == 'fault') {
        // ошибка при проведении платежа
        Cucs::fetch($templateDir . 'pay_cancel.tpl', array('form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . intval($_REQUEST['ORDER_ID']), 'e' => ''));
    }

} else {

    $arOrder = CSaleOrder::GetByID($settings['order_id']);
    if (($arOrder['CANCELED'] == 'N') && ($arOrder['PS_STATUS'] != 'Y')) {

        if (!empty($_POST['ready_to_pay'])) {
            $soapClient = Cucs::newSoap($settings);
            $request = Cucs::prepareOrder($settings);
            try {
                CSaleOrder::StatusOrder($settings['order_id'], 'E');
                CSaleOrder::Update($settings['order_id'], array('PS_STATUS' => ''));

                $info = $soapClient->register($request);
                // всё ок, зарегистрировали, перенаправляем на платёжную систему
                Cucs::fetch($templateDir . 'register_ok.tpl', array(
                                                                        'redirect_url' => $info->redirect_url,
                                                                        'session' => $info->session));
            } catch (SoapFault $fault) {
                // ошибка, предлагаем попробовать снова
                Cucs::fetch($templateDir . 'register_fault.tpl', array(
                                                                            'error_code' => $fault->faultcode,
                                                                            'error_string' => $fault->faultstring,
                                                                            'form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . intval($_REQUEST['ORDER_ID'])));
            } catch (Exception $e) {
                Cucs::fetch($templateDir . 'pay_fault.tpl', array('form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'], 'e' => $e->__toString()));
            }
        } else {
            // выводим форму оплаты
            Cucs::fetch($templateDir . 'prepare.tpl', array(
                                                                'sum' => $settings['order_sum'],
                                                                'action' => $settings['return_url'],
                                                                'arOrder' => $arOrder,
                                                              ), false);
        }
    }

}
